/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.google.common.base.Preconditions;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import icyllis.annotations.ApiStatus;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.forge.LocalStorage;
import icyllis.modernui.graphics.font.GlyphManager;
import icyllis.modernui.text.Emoji;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FontCollection {
    @Nonnull
    public static final FontCollection SANS_SERIF;
    @Nonnull
    public static final FontCollection SERIF;
    @Nonnull
    public static final FontCollection MONOSPACED;
    @Deprecated
    @Nullable
    public static final Font sBuiltInFont;
    @Nonnull
    @ApiStatus.Internal
    public static final Font sSansSerifFont;
    @Deprecated
    public static boolean sJavaTooOld;
    private static final List<String> sFontFamilyNames;
    @ApiStatus.Internal
    public static final List<Font> sAllFontFamilies;
    static final Map<String, FontCollection> sSystemFontMap;
    public static final int GC_M_MASK;
    public static final int REPLACEMENT_CHARACTER = 65533;
    private static final int[] sStickyWhitelist;
    @Nonnull
    private final Font[] mFonts;

    @Deprecated
    private static void checkJava() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            ModernUI.LOGGER.fatal(ModernUI.MARKER, "Java version is missing");
        } else {
            try {
                int majorNumber = Integer.parseInt(javaVersion.split("\\.")[0]);
                if (majorNumber < 11 && LocalStorage.checkOneTimeEvent(1)) {
                    ModernUI.get().warnSetup("warning.modernui.old_java", "11.0.9", javaVersion);
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                ModernUI.LOGGER.warn(GlyphManager.MARKER, "Failed to check major java version: {}", (Object)javaVersion, (Object)e);
            }
            if (javaVersion.startsWith("1.8")) {
                try {
                    int update = Integer.parseInt(javaVersion.split("_")[1].split("-")[0]);
                    if (update < 201) {
                        sJavaTooOld = true;
                        ModernUI.LOGGER.warn(GlyphManager.MARKER, "Java {} is too old to use external fonts", (Object)javaVersion);
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "Failed to check java version update: {}", (Object)javaVersion, (Object)e);
                }
            }
        }
    }

    public static List<String> getFontFamilyNames() {
        return sFontFamilyNames;
    }

    @Nonnull
    public static FontCollection getSystemFont(@Nonnull String familyName) {
        FontCollection t = sSystemFontMap.get(familyName);
        return t == null ? SANS_SERIF : t;
    }

    public static boolean doesNotNeedFontSupport(int c) {
        return c == 173 || c == 847 || c == 1564 || 8204 <= c && c <= 8207 || 8234 <= c && c <= 8238 || 8294 <= c && c <= 8297 || c == 65279 || FontCollection.isVariationSelector(c);
    }

    public static boolean isStickyWhitelisted(int c) {
        for (int value : sStickyWhitelist) {
            if (value != c) continue;
            return true;
        }
        return false;
    }

    public static boolean isCombining(int c) {
        return (UCharacterProperty.getMask((int)UCharacter.getType((int)c)) & GC_M_MASK) != 0;
    }

    public static boolean isVariationSelector(int c) {
        return c >= 917760 && c <= 918015 || c >= 65024 && c <= 65039;
    }

    private FontCollection(@Nonnull Font[] fonts) {
        Preconditions.checkArgument((fonts.length > 0 ? 1 : 0) != 0, (Object)"Font set cannot be empty");
        this.mFonts = fonts;
    }

    public List<Run> itemize(@Nonnull char[] text, int offset, int limit) {
        int nextCh;
        char _c2;
        it.unimi.dsi.fastutil.Arrays.ensureFromTo((int)text.length, (int)offset, (int)limit);
        if (offset == limit) {
            return Collections.emptyList();
        }
        ObjectArrayList result = new ObjectArrayList();
        Run lastRun = null;
        Font lastFamily = null;
        int prevCh = 0;
        int next = offset;
        int index = offset;
        int _c1 = text[index];
        if (Character.isHighSurrogate((char)_c1) && index + 1 < limit) {
            _c2 = text[index + 1];
            if (Character.isLowSurrogate(_c2)) {
                nextCh = Character.toCodePoint((char)_c1, _c2);
                ++index;
            } else {
                nextCh = Character.isSurrogate((char)_c1) ? 65533 : _c1;
            }
        } else {
            nextCh = Character.isSurrogate((char)_c1) ? 65533 : _c1;
        }
        ++index;
        boolean running = true;
        do {
            int ch = nextCh;
            int pos = next;
            next = index;
            if (index < limit) {
                _c1 = text[index];
                if (Character.isHighSurrogate((char)_c1) && index + 1 < limit) {
                    _c2 = text[index + 1];
                    if (Character.isLowSurrogate(_c2)) {
                        nextCh = Character.toCodePoint((char)_c1, _c2);
                        ++index;
                    } else {
                        nextCh = Character.isSurrogate((char)_c1) ? 65533 : _c1;
                    }
                } else {
                    nextCh = Character.isSurrogate((char)_c1) ? 65533 : _c1;
                }
                ++index;
            } else {
                running = false;
            }
            boolean shouldContinueRun = false;
            if (FontCollection.doesNotNeedFontSupport(ch)) {
                shouldContinueRun = true;
            } else if (lastFamily != null && (FontCollection.isStickyWhitelisted(ch) || FontCollection.isCombining(ch))) {
                shouldContinueRun = lastFamily.canDisplay(ch);
            }
            if (!shouldContinueRun) {
                Font family = this.getFamilyForChar(ch);
                if (pos == 0 || family != lastFamily) {
                    int start = pos;
                    if (pos != 0 && (FontCollection.isCombining(ch) || Emoji.isEmojiModifier(ch) && Emoji.isEmojiBase(prevCh))) {
                        int prevLength = Character.charCount(prevCh);
                        if (lastRun != null) {
                            lastRun.mEnd -= prevLength;
                            if (lastRun.mStart == lastRun.mEnd) {
                                result.remove((Object)lastRun);
                            }
                        }
                        start -= prevLength;
                    }
                    if (lastFamily == null) {
                        start = 0;
                    }
                    Run run = new Run(family, start, 0);
                    result.add((Object)run);
                    lastRun = run;
                    lastFamily = family;
                }
            }
            prevCh = ch;
            if (lastRun == null) continue;
            lastRun.mEnd = next;
        } while (running);
        if (lastFamily == null) {
            result.add((Object)new Run(this.mFonts[0], 0, limit));
        }
        return result;
    }

    @Nonnull
    public Font[] getFonts() {
        return this.mFonts;
    }

    private Font getFamilyForChar(int ch) {
        for (Font font : this.mFonts) {
            if (!font.canDisplay(ch)) continue;
            return font;
        }
        for (Font font : sAllFontFamilies) {
            if (!font.canDisplay(ch)) continue;
            return font;
        }
        return this.mFonts[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontCollection that = (FontCollection)o;
        return Arrays.equals(this.mFonts, that.mFonts);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mFonts);
    }

    static {
        sAllFontFamilies = new ArrayList<Font>();
        sSystemFontMap = new HashMap<String, FontCollection>();
        FontCollection.checkJava();
        GraphicsEnvironment.getLocalGraphicsEnvironment().preferLocaleFonts();
        Object[] families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ROOT);
        Font sansSerif = null;
        for (String string : families) {
            Font font = new Font(string, 0, 1);
            sAllFontFamilies.add(font);
            if (!string.equals("SansSerif")) continue;
            sansSerif = font;
        }
        if (sansSerif == null) {
            sansSerif = new Font("SansSerif", 0, 1);
            ModernUI.LOGGER.warn(GlyphManager.MARKER, "Sans Serif is missing");
        }
        sSansSerifFont = sansSerif;
        sFontFamilyNames = new ObjectArrayList(families);
        Font builtIn = null;
        if (!sJavaTooOld) {
            try (InputStream stream = FontCollection.class.getResourceAsStream("/assets/modernui/font/biliw.otf");){
                if (stream != null) {
                    builtIn = Font.createFont(0, stream);
                    sAllFontFamilies.add(builtIn);
                } else {
                    ModernUI.LOGGER.debug(GlyphManager.MARKER, "Built-in font was missing");
                }
            }
            catch (FontFormatException | IOException e) {
                ModernUI.LOGGER.error(GlyphManager.MARKER, "Built-in font failed to load", (Throwable)e);
            }
        }
        sBuiltInFont = builtIn;
        for (Font fontFamily : sAllFontFamilies) {
            FontCollection fontCollection = new FontCollection(new Font[]{fontFamily, sansSerif});
            String family = fontFamily.getFamily(Locale.ROOT);
            FontCollection fontCollection2 = sSystemFontMap.putIfAbsent(family, fontCollection);
            if (fontCollection2 == null) continue;
            ModernUI.LOGGER.warn(GlyphManager.MARKER, "Duplicated font family: {}", (Object)family);
        }
        SANS_SERIF = sSystemFontMap.get("SansSerif");
        SERIF = sSystemFontMap.get("Serif");
        MONOSPACED = sSystemFontMap.get("Monospaced");
        Preconditions.checkState((SANS_SERIF != null ? 1 : 0) != 0, (Object)"Sans Serif font is missing");
        Preconditions.checkState((SERIF != null ? 1 : 0) != 0, (Object)"Serif font is missing");
        Preconditions.checkState((MONOSPACED != null ? 1 : 0) != 0, (Object)"Monospaced font is missing");
        GC_M_MASK = UCharacterProperty.getMask((int)8) | UCharacterProperty.getMask((int)7) | UCharacterProperty.getMask((int)6);
        sStickyWhitelist = new int[]{33, 44, 45, 46, 58, 59, 63, 160, 8208, 8209, 8239, 9792, 9794, 9877};
    }

    public static class Run {
        private final Font mFont;
        private final int mStart;
        private int mEnd;

        public Run(Font font, int start, int end) {
            this.mFont = font;
            this.mStart = start;
            this.mEnd = end;
        }

        public Font getFamily() {
            return this.mFont;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }
    }
}

